﻿using System;
using System.Globalization;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;

namespace VA.PPMS.CRM.Plugins.Helper
{
    public static class FabricHelper
    {
        //const string StorageAccountKey = "sIQaKhowoyzjoI0l0mAjtN9AjBCPZHqoMCrF2iEggoCo93jI1N1gVVibtQRD108spEBVM+Y4t9jzZskI9gyIyQ==";
        //const string StorageAccountName = "vac20hsmtestppms01";
        //const string StorageAccountResource = "crinitiatetest/messages";
        //const string BaseAddress = "https://vac20hsmtestppms01.queue.core.windows.net/";

        const string StorageAccountKey = "AGzRK9Z27pqbUgW9CH0AvcONvz3aGc1n21fGGoO8nAecJJrmrmAXka9vhdUrM8Vv854pDtfunHmkhUHkS3in3g==";
        const string StorageAccountName = "vac20hsmdevtestppms01";
                                            
        const string StorageAccountResource = "crinitiate/messages";
        const string QueueBaseAddress = "https://vac20hsmdevtestppms01.queue.core.usgovcloudapi.net/";
        const string TableBaseAddress = "https://vac20hsmdevtestppms01.table.core.usgovcloudapi.net/";

        public static void SubmitToQueue(string message)
        {
            try
            {
                using (var client = new HttpClient())
                {
                    client.BaseAddress = new Uri(QueueBaseAddress);

                    var requestDate = DateTime.UtcNow.ToString("R", CultureInfo.InvariantCulture);
                    const string storageServiceVersion = "2012-02-12";

                    string messageText = String.Format("<QueueMessage><MessageText>{0}</MessageText></QueueMessage>", message);
                    var utf8Encoding = new UTF8Encoding();
                    var messageContent = utf8Encoding.GetBytes(messageText);
                    var messageLength = messageContent.Length;

                    var canonicalizedHeaders = string.Format("x-ms-date:{0}\nx-ms-version:{1}", requestDate, storageServiceVersion);

                    var canonicalizedResource = string.Format("/{0}/{1}", StorageAccountName, StorageAccountResource);

                    var stringToSign = string.Format("{0}\n\n\n{1}\n\n\n\n\n\n\n\n\n{2}\n{3}",
                        "POST",
                        messageLength,
                        canonicalizedHeaders,
                        canonicalizedResource);

                    var authorizationHeader = CreateAuthorizationHeader(stringToSign, StorageAccountName, StorageAccountKey);

                    client.DefaultRequestHeaders.Add("x-ms-date", requestDate);
                    client.DefaultRequestHeaders.Add("x-ms-version", storageServiceVersion);
                    client.DefaultRequestHeaders.Add("Authorization", authorizationHeader);

                    var result = client.PostAsync(StorageAccountResource, new ByteArrayContent(messageContent)).GetAwaiter().GetResult();
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
            }
        }

        /// <summary>
        /// Lookup NPI status from validation list
        /// </summary>
        /// <param name="npi">Reference NPI</param>
        /// /// <param name="npiType">Reference NPI Type</param>
        public static string GetNpiStatus(string npi, string npiType, Microsoft.Xrm.Sdk.ITracingService tracingService)
        {
            try
            {
                tracingService.Trace("Creating Request to Query Nppes Azure Data Table");
                //var uri = string.Format("{0}npistatus(PartitionKey='Active',RowKey='{1}')", TableBaseAddress, npi);
                var uri = string.Format("{0}npistatus()?$filter= Status eq 'Active' and Npi eq '{1}' and NpiType eq '{2}'", TableBaseAddress, npi, npiType);
                var request = (HttpWebRequest)WebRequest.Create(uri);
                request.ContentLength = 0;
                request.Headers.Add("x-ms-date", DateTime.UtcNow.ToString("R", CultureInfo.InvariantCulture));

                const string storageServiceVersion = "2015-12-11";

                var resource = request.RequestUri.PathAndQuery;
                if (resource.Contains("?"))
                {
                    resource = resource.Substring(0, resource.IndexOf("?"));
                }

                string stringToSign = string.Format("{0}\n{1}\n{2}\n{3}\n/{4}{5}",
                    request.Method,
                    request.Headers["Content-MD5"],
                    request.Headers["Content-Type"],
                    request.Headers["x-ms-date"],
                    StorageAccountName,
                    resource);

                var authorizationHeader = CreateAuthorizationHeader(stringToSign, StorageAccountName, StorageAccountKey);

                request.Headers.Add("x-ms-version", storageServiceVersion);
                request.Headers.Add("Authorization", authorizationHeader);
                request.Accept = "application/json;odata=nometadata";

                var response = request.GetResponse();

                using (var sr = new StreamReader(response.GetResponseStream()))
                {
                    tracingService.Trace("Success on Nppes Azure Data Table Query");
                    return sr.ReadToEnd();
                }
            }
            catch (WebException e)
            {
                tracingService.Trace("Web Exception on Query Nppes Azure Data Table {0}", e.ToString());
                return null;
            }
            catch (Exception e)
            {
                tracingService.Trace("Exception on Query Nppes Azure Data Table {0}", e.ToString());
                return null;
            }
        }

        private static string CreateAuthorizationHeader(string canonicalizedString, string storageAccountName, string storageAccountKey)
        {
            string signature;

            using (var hmacSha256 = new HMACSHA256(Convert.FromBase64String(storageAccountKey)))
            {
                var dataToHmac = Encoding.UTF8.GetBytes(canonicalizedString);
                signature = Convert.ToBase64String(hmacSha256.ComputeHash(dataToHmac));
            }

            var authorizationHeader = string.Format(CultureInfo.InvariantCulture, "SharedKey {0}:{1}", storageAccountName, signature);

            return authorizationHeader;
        }

        private static string GetPartitionKey(string npi)
        {
            return npi.Substring(0, 2);
        }
    }
}
